#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Twisting TubeMod01.fsh   by    smlk0 
//https://www.shadertoy.com/view/ddcfzH
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 center_uv(vec2 original_uv) {
	
    original_uv /= iResolution.y;
	return vec2((original_uv.x * 2.0 - iResolution.x/iResolution.y), (original_uv.y * 2.0 - 1.0));
}

vec2 rotation_2d(vec2 point, float angle) {
	
	float s = sin(angle);
	float c = cos(angle);
	return point * mat2(vec2(c, -s),
						vec2(s, c));
}

float tube_twist_multiplier = 0.07;
float tube_rotation_speed = -0.25;
float origin_twist_multiplier = -0.5;
float origin_rotation_speed = 0.5;
float tube_ridge_frequency = 10.0;
float tube_ridge_intencity = 3.0;
float distance_twist = 0.3;

float sdf_tube(vec3 point, float offset_x, float offset_y, float radius) {
	
	point.xy = rotation_2d(point.xy, iTime *  origin_rotation_speed);
	point.xy = rotation_2d(point.xy, point.z * origin_twist_multiplier);
	point.xy = rotation_2d(point.xy, length(point.xy) * distance_twist);
	point.xy = vec2((point.x - offset_x), (point.y - offset_y));
	point.xy = rotation_2d(point.xy, iTime * tube_rotation_speed);
	point.xy = rotation_2d(point.xy, point.z * tube_twist_multiplier);
	float displacement = tube_ridge_intencity * sin(atan((point.x), (point.y)) * tube_ridge_frequency);
	point.xy = point.xy + normalize(point.xy) * displacement;
	
	return length(vec2(point.x, point.y)) - radius;
}

float tube_x = 0.0;
float tube_y = 25.0;
float tube_radius = 20.0;
float march_step_scale = 0.1;

float distance_to_hit(vec3 point) {
	
	float final_distance = sdf_tube(point, tube_x, tube_y, tube_radius);
	return final_distance * march_step_scale;
}

vec3 calculate_normal(vec3 point, float current_distance) {

	const float epsilon = 0.001;
	
	float gradient_x =
	current_distance - distance_to_hit(vec3(point.x - epsilon, point.y, point.z));
	float gradient_y =
	current_distance - distance_to_hit(vec3(point.x, point.y - epsilon, point.z));
	float gradient_z =
	current_distance - distance_to_hit(vec3(point.x, point.y, point.z - epsilon));
	
	return normalize(vec3(gradient_x, gradient_y, gradient_z));
}

const vec3 BLACK = vec3(0.0, 0.0, 0.0);
const vec3 RED = vec3(1.0, 0.0, 0.0);

const vec3 directional_light = vec3(0.0, 0.0, -0.7);

int max_steps = 1000;
float max_distance = 100.0;
float tolerance = 0.0001;
float fog_end = 100.0;
float fog_start = 25.0;

vec3 ray_march(vec3 origin, vec3 direction) {
	
	float total_distance = 0.0;
	
	for (int i = 0; i < max_steps; ++i) {
		
		vec3 current_position = origin + total_distance * direction;
		float current_distance = distance_to_hit(current_position);
		
		if (current_distance < tolerance) {
			
			vec3 normal = calculate_normal(current_position, current_distance);
			
			vec3 color = RED * dot(normal, directional_light);
			
			float fog_factor = (1.0 - (fog_end - total_distance)/(fog_end - fog_start));
			color = mix(color, BLACK, fog_factor);
			
			return color;
		}
		
		if (total_distance > max_distance) {
			
			break;
		}
		
		total_distance += current_distance;
	}
	
	return BLACK;
}

float uv_plane_distance = 0.4;

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
	
	vec3 camera_position = vec3(0.0, 0.0, -5.0);
	vec2 uv = center_uv(fragCoord);
	vec3 camera_ray_direction = vec3(uv, uv_plane_distance);
	
	fragColor = vec4(ray_march(camera_position, camera_ray_direction), 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

